#version 330
in vec2 uv;
out vec4 fragColor;

uniform float phi, phiInv, omegaTime;
uniform float fibTable[128];
uniform float primeTable[128];

const int NUM_SLOTS = 32;  // conservative saturation

float prismatic(int id, float r){
    float phi_h = pow(phi, float(id % 16));
    float fib_h = fibTable[id % 128];
    float prime_h = primeTable[id % 128];
    float Omega = 0.5 + 0.5*sin(omegaTime + float(id)*0.01);
    float r_dim = pow(r, float((id%7)+1));
    return sqrt(phi_h * fib_h * prime_h * Omega) * r_dim;
}

void main(){
    float r = length(uv - 0.5) * 2.0;
    int bits[NUM_SLOTS];
    for(int i=0;i<NUM_SLOTS;i++){
        float v = prismatic(i, r);
        bits[i] = v > sqrt(phi) ? 1 : 0;
    }
    // pack first 16 bits into RGBA
    fragColor = vec4(
        float(bits[0]*8 + bits[1]*4 + bits[2]*2 + bits[3]) / 15.0,
        float(bits[4]*8 + bits[5]*4 + bits[6]*2 + bits[7]) / 15.0,
        float(bits[8]*8 + bits[9]*4 + bits[10]*2 + bits[11]) / 15.0,
        float(bits[12]*8 + bits[13]*4 + bits[14]*2 + bits[15]) / 15.0
    );
}
